local WINTER_TEMP = -5

local function currentSeasonName(self)
    if not self or not self.owner then return nil end

    local cur = self.owner.currentSeason
    if cur == nil then return nil end 

    if self.seasons and type(self.seasons) == "table" then
        local def = self.seasons[(cur or 0) + 1]
        if def and type(def.name) == "string" then
            return def.name:lower()
        end
    end

    local env = self.owner.environment or self.environment
    if env and env.seasons and type(env.seasons) == "table" then
        local def = env.seasons[(cur or 0) + 1]
        if def and type(def.name) == "string" then
            return def.name:lower()
        end
    end

    local fallback = { [1]="spring", [2]="summer", [3]="autumn", [4]="winter" }
    return fallback[cur]
end

local function setTempFlat(updater, v)
    if not updater then return end
    if updater.targetMin ~= nil then updater.targetMin = v end
    if updater.targetMax ~= nil then updater.targetMax = v end
    if updater.minTarget ~= nil then updater.minTarget = v end
    if updater.maxTarget ~= nil then updater.maxTarget = v end
    if updater.currentMin ~= nil then updater.currentMin = v end
    if updater.currentMax ~= nil then updater.currentMax = v end
    if updater.min ~= nil then updater.min = v end
    if updater.max ~= nil then updater.max = v end
    if updater.value ~= nil then updater.value = v end
end

local function ForceWinterMinus5_update(self, dt)
    if self and self.temperatureUpdater then
        local name = currentSeasonName(self)
        if name == "winter" then
            setTempFlat(self.temperatureUpdater, WINTER_TEMP)
        end
    end
end

Weather.update = Utils.appendedFunction(Weather.update, ForceWinterMinus5_update)
