
source(Utils.getFilename("src/SuperStrength.lua", g_currentModDirectory))
source(Utils.getFilename("src/SuperStrengthEvent.lua", g_currentModDirectory))

SuperStrengthLoader = {}
SuperStrengthLoader.currentModDirectory = g_currentModDirectory

SuperStrengthLoader.specName = "superStrength"
SuperStrengthLoader.specClassName = "SuperStrength"
SuperStrengthLoader.specFileName = "src/SuperStrength.lua"
SuperStrengthLoader.specFilePath = Utils.getNoNil(Utils.getFilename(SuperStrengthLoader.specFileName, SuperStrengthLoader.currentModDirectory), "") 

function SuperStrengthLoader:addSpecialization()
    if g_specializationManager:getSpecializationByName(SuperStrengthLoader.specName) == nil then
        g_specializationManager:addSpecialization(SuperStrengthLoader.specName, SuperStrengthLoader.specClassName, SuperStrengthLoader.specFilePath, nil)
    end

    for handToolType, handTool in pairs(g_handToolTypeManager.types) do
        if handTool ~= nil then
            for name in pairs(handTool.specializationsByName) do
                if name == "hands" then
                    local specializationObject = g_specializationManager:getSpecializationObjectByName(SuperStrengthLoader.specName)
                    if handTool.specializationsByName[SuperStrengthLoader.specName] == nil then
                        handTool.specializationsByName[SuperStrengthLoader.specName] = specializationObject
                        table.insert(handTool.specializationNames, SuperStrengthLoader.specName)
                        table.insert(handTool.specializations, specializationObject)
                    end
                end
            end
        end
    end
end

TypeManager.finalizeTypes = Utils.appendedFunction(TypeManager.finalizeTypes, SuperStrengthLoader.addSpecialization)

